local t = Def.ActorFrame {};

local playMode = GAMESTATE:GetPlayMode()

local sStage = ""
sStage = GAMESTATE:GetCurrentStage()

if playMode ~= 'PlayMode_Regular' and playMode ~= 'PlayMode_Rave' and playMode ~= 'PlayMode_Battle' then
  sStage = playMode;
end;

if not (GAMESTATE:IsCourseMode() or GAMESTATE:IsExtraStage() or GAMESTATE:IsExtraStage2()) then
        local tRemap = {
                Stage_Event             = 0,
                Stage_1st               = 1,
                Stage_2nd               = 2,
                Stage_3rd               = 3,
                Stage_4th               = 4,
                Stage_5th               = 5,
                Stage_6th               = 6,
        };

        local nSongCount = tRemap[sStage] + (GAMESTATE:GetCurrentSong():GetStageCost()-1);

        if nSongCount >= PREFSMAN:GetPreference("SongsPerPlay") then
        sStage = "Stage_Final";
        else
                sStage = sStage;
        end;
end;

local t = Def.ActorFrame {};
t[#t+1] = Def.Quad {
			InitCommand=cmd(zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y);
			OnCommand=cmd(diffuse,color("#0E2B32");diffusebottomedge,color("#000000"));
		};

t[#t+1] = LoadActor("_spinbg") .. {
		InitCommand=cmd(Center;diffusealpha,0.4;);
		OnCommand=cmd(blend,'BlendMode_WeightedMultiply';spin;effectmagnitude,0,0,-5;);
	};
	
t[#t+1] = LoadActor("_rblights") .. {
		InitCommand=cmd(zoomy,0.8;zoomx,0.7;Center;);
		OnCommand=cmd(diffusealpha,0;sleep,1.8;smooth,0.2;diffusealpha,1;sleep,0.4;smooth,2;diffusealpha,0;);
	};	

t[#t+1] = LoadActor("_onikeybox") .. {
		InitCommand=cmd(Center;zoom,1.4;diffusealpha,0;);
		OnCommand=cmd(decelerate,0.7;diffusealpha,1;zoom,0.8;sleep,3.2;smooth,0.5;diffusealpha,0;zoom,0.6;rotationz,80;);
	};


t[#t+1] = Def.Quad {
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,color("#000000");diffusealpha,0);
		OnCommand=cmd(sleep,3.5;smooth,0.7;diffuse,color("#000000")sleep,0.6;);
};
	
t[#t+1] = LoadActor("_oniglowbox") .. {
		InitCommand=cmd(Center;zoom,0.8;diffusealpha,0;blend,'BlendMode_Add');
		OnCommand=cmd(sleep,0.7;smooth,1;diffusealpha,1;smooth,0.5;diffusealpha,0;smooth,0.5;diffusealpha,1;smooth,0.5;diffusealpha,0;smooth,0.7;diffusealpha,1;smooth,0.5;rotationz,-45;zoom,1.2;diffusealpha,0);
	};	
	

t[#t+1] = Def.ActorFrame {
	InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-10);	
	LoadActor( THEME:GetPathG("ScreenStageInformation", "Stage " .. ToEnumShortString(sStage) ) ) .. {
		OnCommand=cmd(diffusealpha,0;zoom,0.6;smooth,1;zoom,0.75;diffusealpha,1;sleep,2.9;smooth,0.5;diffusealpha,0;zoom,0.6;rotationz,-80;);
	};
};	

	
t[#t+1] = LoadActor("_screenstage.ogg") .. {
        OnCommand=cmd(queuecommand,("Play"));
		PlayCommand=cmd(play;);
    };
	
t[#t+1] = Def.Quad {
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,color("#CCCCCC");diffusealpha,1);
		OnCommand=cmd(smooth,0.6;diffusealpha,0;);
};		

return t